import { FiEdit, FiLayers } from "react-icons/fi";
import { MdAssignmentAdd } from "react-icons/md";
import { Tooltip } from "react-tooltip";
export const getCEColumns = (router, rows = [], setCEReviewModalOpen, setChapterId) => {
    // Check if any row has a non-empty stage_movements array
    const hasStageMovements = rows.some(
        (row) => Array.isArray(row.stage_movements) && row.stage_movements.length > 0
    );

    const columns = [
        {
            label: "S.No",
            name: "S.No",
            cell: (row, index) => index + 1,
        },
        {
            label: "Book Title",
            name: "Book Title",
            selector: (row) => row.book.book_title,
        },
        {
            label: "Chapter Title",
            name: "Chapter Title",
            selector: (row) => row.chap_title,
            styleTypeUiPatterns: "badge",
        },
        {
            label: "Manuscript ID",
            name: "Manuscript ID",
            selector: (row) => row.chap_manuscriptID,
        },
        {
            label: "Editor Name",
            name: "Author",
            cell: (row) => row.ce_editing?.[0]?.user?.user_name || "-",
            styleTypeUiPatterns: "badge",
        },
        // {
        //     label: "Author",
        //     name: "Author",
        //     cell: (row) => `${row.chap_firstName} ${row.chap_lastName}`,
        //     styleTypeUiPatterns: "badge",
        // },
        // {
        //     label: "Email",
        //     name: "Email",
        //     selector: (row) => row.chap_corresAuEmail,
        // },
        // {
        //     label: "Status",
        //     name: "Status",
        //     selector: (row) => row.chap_status,
        //     styleTypeUiPatterns: "badge",
        // },
        // {
        //     label: "P+ Status",
        //     name: "P+ Status",
        //     selector: (row) => row.pstatus?.pstatus_name || "",
        //     styleTypeUiPatterns: "badge",
        // },
        // {
        //     label: "Due Date",
        //     name: "Due Date",
        //     selector: (row) => row.chap_pdueDate,
        //     styleTypeUiPatterns: "badge",
        // },
        // {
        //     label: "Copy Editing",
        //     name: "Copy Editing",
        //     selector: (row) => row.chap_copyEditing,
        //     styleTypeUiPatterns: "badge",
        //     styleTypeColors: "warning",
        // },
          {
            label: "CE Send Date",
            name: "CE Send Date",
            selector: (row) => row.ce_editing?.[0]?.ce_sent_date || "-",
            grow: 2,
            wrap: true,
        },
        {
            label: "Send Comments",
            name: "Comments",
            selector: (row) => row.ce_editing?.[0]?.ce_sent_comments || "-",
            grow: 2,
            wrap: true,
        },
        
        {
            label: "CE Recived Date",
            name: "CE Recived Date",
            selector: (row) => row.ce_editing?.[0]?.ce_received_date || "-",
            grow: 2,
            wrap: true,
        },
        {
            label: "Received Comments",
            name: "Received Comments",
            selector: (row) => row.ce_editing?.[0]?.ce_received_comment || "-",
            grow: 2,
            wrap: true,
        },
        {
            label: "Status",
            name: "Status",
            selector: (row) => {
                const statusMap = {
                    1: "Sent",
                    2: "Accepted",
                    3: "Rejected",
                    4: "Timeout",
                    5: "Uploaded",
                };

                const status = row.ce_editing?.[0]?.ce_status;
                return statusMap[status] || "-";
            },
            grow: 2,
            wrap: true,
        },
      
        // ...(hasStageMovements
        //     ? [
        //         {
        //             label: "RC Send Date",
        //             name: "RC Send Date",
        //             cell: (row) => row.stage_movements?.[0]?.stage_dispachDate || "",
        //         },

        //         {
        //             label: "RC Send Comments",
        //             name: "RC Send Comments",
        //             cell: (row) => row.stage_movements?.[0]?.stage_notes || "",
        //             grow: 2,
        //             wrap: true,
        //         },
        //         {
        //             label: "RC Status",
        //             name: "RC Status",
        //             cell: (row) => row.stage_movements?.[0]?.status.status_name || "",
        //             grow: 2,
        //             wrap: true,
        //         },
        //     ]
        //     : []),
        {
            label: "Action",
            name: "Action",
            cell: (row) => {
                const status = row.ce_editing?.[0]?.ce_status;

                // Only show button if status is 4 or empty
                if (status === 4 || status === null || status === undefined || status === "") {
                    return (
                        <div className="flex space-x-3">
                            <button
                                onClick={() => {
                                    setCEReviewModalOpen(true);
                                    setChapterId(row.chap_pid);
                                }}
                                aria-label="CE Assignment"
                                data-tooltip-id={`CE-tooltip-${row.chap_pid}`}
                                data-tooltip-content="CE Assignment"
                                className="text-green-600 hover:text-green-800 cursor-pointer"
                                type="button"
                            >
                                <MdAssignmentAdd size={20} />
                                <Tooltip
                                    id={`CE-tooltip-${row.chap_pid}`}
                                    place="bottom"
                                    style={{
                                        backgroundColor: "#10B981",
                                        color: "#fff",
                                        fontSize: "12px",
                                        borderRadius: "4px",
                                        padding: "6px 10px",
                                    }}
                                />
                            </button>
                        </div>
                    );
                }

                // Return nothing (or a placeholder) if condition not met
                return null;
            },
            ignoreRowClick: true,
        }

    ];

    return columns;
};
